<!DOCTYPE HTML>
<?PHP
	require 'functions.php';
	checkLogin();
	$db_link = connect();

	//Select from CUSTOMER
	if (isset($_POST['cust_search'])){
        
		$cust_search_no = sanitize($db_link, $_POST['cust_search_no']);
		$cust_search_name = sanitize($db_link, $_POST['cust_search_name']);
		$cust_search_addr = sanitize($db_link, $_POST['cust_search_addr']);
		$cust_search_occup = sanitize($db_link, $_POST['cust_search_occup']);
        
        if(empty($cust_search_no)&&empty($cust_search_name)&&empty($cust_search_addr)&&empty($cust_search_occup)){
           header('Location: cust_search.php'); 
        }
        else{
		//Defining WHERE condition
		$where = "";
		$title = "Customers";

		if ($cust_search_no != ""){
			$where = "cust_no LIKE '%$cust_search_no%'";
			$title = $title.' with number "'.$cust_search_no.'"';
		}
		if ($cust_search_no != "" AND $cust_search_name != "") $where = $where.' AND ';

		if ($cust_search_name != ""){
			$where = $where."cust_name LIKE '%$cust_search_name%'";
			$title = $title.' named "'.ucwords($cust_search_name).'"';
		}
		if (($cust_search_no != "" OR $cust_search_name != "") AND $cust_search_addr != "") $where = $where.' AND ';

		if ($cust_search_addr != ""){
			$where = $where."cust_address LIKE '%$cust_search_addr%'";
			$title = $title.' from "'.ucwords($cust_search_addr).'"';
		}
		if (($cust_search_no != "" OR $cust_search_name != "" OR $cust_search_addr != "") AND $cust_search_occup != "") $where = $where.' AND ';

		if ($cust_search_occup != ""){
			$where = $where."cust_occup LIKE '%$cust_search_occup%'";
			$title = $title.' working as "'.ucwords($cust_search_occup).'"';
		}

		$sql_custsearch = "SELECT * FROM customer LEFT JOIN custsex ON customer.custsex_id = custsex.custsex_id WHERE $where ORDER BY customer.cust_id";
		$query_custsearch = mysqli_query($db_link, $sql_custsearch);
		checkSQL($db_link, $query_custsearch);

		//Make array for exporting data
		$cust_exp_date = date("Y-m-d",time());
		$_SESSION['cust_export'] = array();
		$_SESSION['cust_exp_title'] = 'customers-search_'.$cust_exp_date; }
	}
	else header('Location: start.php');
?>

<html>
	<?PHP includeHead('Customer Search Result',1) ?>
	<body>
		<!-- MENU -->
		<?PHP includeMenu(2); ?>
		<div id="menu_main"> <!--
			<a href="cust_search.php" id="item_selected">Search</a>
			<a href="cust_new.php">New Customer</a>
			<a href="cust_act.php">Active Customers</a>
			<a href="cust_inact.php">Inactive Customers</a> -->
            <a href="cust_search.php">Back</a>
		</div>

        <!-- tables pagination -->
        <link rel="stylesheet" href="css/paginationTable.css">
        
        <link href="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css" rel="stylesheet">   
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
        <link rel="stylesheet" href="http://cdn.datatables.net/1.10.2/css/jquery.dataTables.min.css">
        <script type="text/javascript" src="http://cdn.datatables.net/1.10.2/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        
        
    <div class="container2">
        
    <h3 class="actCusttHeading">Customer Search Results</h3>
        <h4 style="color: #4682B4; text-align: center;" ><?PHP echo $title; ?></h4>
    <div class="exportCdata">
    <form class="export" action="cust_export.php" method="post">
        <!-- Export Button -->	
        <input type="submit" style="background-color: #4682B4 !important; color: #ffffff;" name="export_cust" value="Export" />	
    </form>
    </div>
    <!-- TABLE: Loan Search Result -->
    <table id="myTable" class="table table-striped table-bordered table-responsive table-hover" >
		<thead>
			<tr> 
            <th scope="col">Cust. No.</th>
            <th scope="col">Name</th>
			<th scope="col">DoB</th>
			<th scope="col">Gender</th>
			<th scope="col">Occupation</th>
			<th scope="col">Address</th>
			<th scope="col">Phone No.</th>
			</tr>                
		</thead>
        <tbody> 
        <?php
           
			$count = 0;
			while ($row_custsearch = mysqli_fetch_assoc($query_custsearch)) { ?>
		<tr>  
            <td data-label="Cust. No."> 
                <a href="customer.php?cust=<?php echo $row_custsearch['cust_id']; ?> "><?php echo $row_custsearch['cust_no']; ?></a>
            </td>
			<td data-label="Name">
                <?php echo $row_custsearch['cust_name'];?>
            </td>
            <td data-label="DoB">
                <?php echo  date("d.m.Y",$row_custsearch['cust_dob']); ?>
            </td>
			<td data-label="Gender"><?php echo $row_custsearch['custsex_name']; ?></td>
			<td data-label="Occupation">
                <?php echo $row_custsearch['cust_occup']; ?>
            </td>
			<td data-label="Address">
                <?php echo $row_custsearch['cust_address']; ?>
            </td>
            <td data-label="Phone No."><?php echo $row_custsearch['cust_phone']; ?></td>
		</tr> 
        <?php                                                    
                                                                           
            //Prepare data for export to Excel file
			array_push($_SESSION['cust_export'], array("Cust No." => $row_custsearch['cust_no'], "Name" => $row_custsearch['cust_name'], "DoB" => date("d.m.Y", $row_custsearch['cust_dob']), "Gender" => $row_custsearch['custsex_name'], "Occupation" => $row_custsearch['cust_occup'], "Address" => $row_custsearch['cust_address'], "Phone No." => $row_custsearch['cust_phone']));
                                                                        
                                                                  
            $count++;   }	?>
        </tbody>  
    </table>
        <hr class="new1" style="border-top: 1px solid #FB788E;">		
    </div>

    <?php include 'views/partial/footer.php'; ?>
    <script src="js/atcMFmainJS.js"></script>
	</body>
<script>
$(document).ready(function(){
    $('#myTable').dataTable();
});
</script>
</html>
